<?php
/**
 * @package EvolutionScript
 * @author: EvolutionScript S.A.C.
 * @Copyright (c) 2010 - 2020, EvolutionScript.com
 * @link http://www.evolutionscript.com
 */

namespace App\Controllers\Api;


use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\RESTful\ResourceController;
use Config\Services;
use Psr\Log\LoggerInterface;

class Departments extends ResourceController
{
    protected $format = 'json';
    protected $modelName = 'App\Models\Departments';
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger); // TODO: Change the autogenerated stub
        helper(['form','html','helpdesk','number','filesystem','text']);
    }

    public function create()
    {
        $api = Services::api();
        if(!$api->validatePermission('departments/create')){
            return $api->showError();
        }
        $validation = Services::validation();
        $validation->setRules([
            'name' => 'required',
            'private' => 'required|in_list[0,1]'
        ],[
            'name' => [
                'required' => lang('Api.error.departmentMissing'),
            ],
            'private' => [
                'required' => lang('Api.error.departmentTypeMissing'),
                'in_list' => lang('Api.error.departmentType')
            ]
        ]);

        if($validation->withRequest($this->request)->run() == false){
            return $api->output(implode(' ', array_values($validation->getErrors())), true);
        }
        $departments = Services::departments();
        $department_id = $departments->create($this->request->getPost('name'), $this->request->getPost('private'),'last');
        return $api->output(['department_id' => $department_id,'message' => lang('Api.departmentCreated')]);
    }

    public function index()
    {
        $api = Services::api();
        if(!$api->validatePermission('departments/read')){
            return $api->showError();
        }
        return $api->output(['departments' => $this->model->select('id, name, private')
            ->orderBy('dep_order','asc')
            ->findAll()]);
    }

    public function show($id = null)
    {
        $api = Services::api();
        if(!$api->validatePermission('departments/read')){
            return $api->showError();
        }
        if($department = $this->model->select('id, name, private')->find($id)){
            return $api->output(['department' => $department]);
        }else{
            return $api->output(lang('Api.error.departmentNotFound'), true);
        }
    }

    public function update($id = null)
    {
        $api = Services::api();
        if(!$api->validatePermission('departments/update')){
            return $api->showError();
        }
        if(!$department = $this->model->find($id)){
            return $api->output(lang('Api.error.departmentNotFound'), true);
        }

        $validation = Services::validation();
        $validation->setRules([
            'name' => 'required',
            'private' => 'required|in_list[0,1]'
        ],[
            'name' => [
                'required' => lang('Api.error.departmentMissing'),
            ],
            'private' => [
                'required' => lang('Api.error.departmentTypeMissing'),
                'in_list' => lang('Api.error.departmentType')
            ]
        ]);

        if($validation->withRequest($this->request)->run() == false){
            return $api->output(implode(' ',array_values($validation->getErrors())), true);
        }else{
            $this->model->protect(false);
            $this->model->update($id, [
                'name' => esc($this->request->getPost('name')),
                'private' => $this->request->getPost('private')
            ]);
            $this->model->protect(true);
            return $api->output(lang('Api.departmentUpdated'));
        }
    }

    public function delete($id = null)
    {
        $api = Services::api();
        if(!$api->validatePermission('departments/delete')){
            return $api->showError();
        }
        $departments = Services::departments();
        if(!$departments->isValid($id)){
            return $api->output(lang('Api.error.departmentNotFound'), true);
        }
        $departments->remove($id);
        return $api->output(lang('Api.departmentRemoved'));
    }
}